﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

//CarClassParts represents a list of car parts for each specific class
public class CarsClassParts
{
    public List<CarPart> Parts { get; private set; } = new List<CarPart>();

    public bool Parse(XElement partsElem)
    {
        try
        {
            //Try to parse each part for this class
            foreach(XElement carPartElem in partsElem.Elements("Part"))
            {
                string id = carPartElem.Attribute("ID").Value;
                string path = carPartElem.Attribute("Path").Value;
                bool tintable = Convert.ToBoolean(carPartElem.Attribute("Tintable").Value);
                bool optional = Convert.ToBoolean(carPartElem.Attribute("Optional").Value);
                int count = Convert.ToInt32(carPartElem.Attribute("Count").Value);

                Parts.Add(new CarPart(id, path, tintable, optional, count));
            }

            return true;    //We succeeded!
        }

        catch(Exception ex)
        {
            return false;
        }
    }
}